\name{simulateData}
\alias{simulateData}
\title{
  Forward simulation of data sets from sienaBayes results
}
\description{
  This function performs forward simulations of
  \code{\link{sienaBayesFit}} results to be used, e.g.,
  for assessing goodness of fit.\cr
  Such simulations are intended to be a sample
  from the posterior predictive distribution.
}
\usage{
simulateData(g, x, xd, thin=1, nstart=x$nwarm,
                            seed=NULL, nbrNodes=1)}
\arguments{
  \item{g}{Integer: group number.}
  \item{x}{A \code{\link{sienaBayesFit}} object.}
  \item{xd}{The \code{\link{sienaGroup}} data set corresponding to \code{x}.}
  \item{thin}{Integer: a parameter for thinning.}
  \item{nstart}{The first iteration in \code{x},
     starting from which parameter values will be used.}
  \item{seed}{Integer: random number seed.}
  \item{nbrNodes}{Number of parallel processes to use.}
}
\details{
 This function takes groupwise simulated parameter values from \code{x}
 for group \code{g}, and simulates data for this group
 for the sequence of these parameters.
 This is done by running \code{\link{siena07}} with \code{returnDeps=TRUE},
 using as \code{thetaValues} the parameters simulated in \code{x},
 and using an algorithm object with \code{nsub=0, simOnly=TRUE}.\cr
 Works only if there are no interactions between three effects;
 and only one dependent network or behavior variable.
}
\value{\code{\link{sienaFit}} object, produced using only Phase 3 of
     \code{\link{siena07}},
     containing a sample from the posterior predictive distribution.\cr
     The simulated dependent variables are in the component \code{sims}
     of the object produced by \code{simulateData}.\cr
     The size of the generated sample is parameter \code{nmain} in the call
     of \code{\link{sienaBayes}} used to generate \code{x},
     divided by \code{thin}.\cr
     See the help page for \code{\link{siena07}} for
     the structure of the simulated dependent variables.
  }
\author{Tom Snijders}
\seealso{\code{\link{sienaBayes}}}
\examples{
  mData <- list()
  for (i in 1:10){
    net <- sienaDependent(array(c(smallNetworks[[1]],smallNetworks[[i+1]]),
                            dim=c(5,5,2)), allowOnly=FALSE)
    num <- coCovar(rep(i,5), warn=FALSE)
    mData[[i]] <- sienaDataCreate(net,num)
  }
# Construct the multigroup dataset:
  (multiData <- sienaGroupCreate(mData))
# specify model
  eff.p <- getEffects(multiData)
  eff.p <- setEffect(eff.p, density, random=TRUE)
  eff.p <- setEffect(eff.p, recip, random=TRUE)
  print(eff.p, includeRandoms=TRUE, dropRates=TRUE)
  alg.ml <- sienaAlgorithmCreate(projname=NULL, prML=2, seed=531, lessMem=TRUE)
  Mu <- c(1,-1,0.5)
  Sig <- matrix(0,3,3)
  diag(Sig) <- 0.25
# Estimate: (warning: the settings of the algorithm are not realistic)
  (bayes.model <- sienaBayes(alg.ml, data=multiData,
       effects=eff.p, nprewarm=5, nwarm=25, nmain=25, nrunMHBatches=2,
       nImproveMH=0,
       initgainGroupwise=0, reductionFactor=0.1,
       priorMu=Mu, priorSigma=Sig, priorKappa=0.09,
       silentstart=TRUE, saveFreq=0))
  (pred.post <- simulateData(1, bayes.model, multiData, seed=321))
  length(pred.post$sims) # set by nmain in call of sienaBayes
# pred.post$sims contains the simulated networks as edge lists:
  pred.post$sims[[25]]
}
% Add one or more standard keywords, see file "KEYWORDS" in the
% R documentation directory.
\keyword{ functions }